import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * Beschreibung: Vorlage zu Aufgabe 3b
 * 
 * @version 2.0 vom 02.10.2025
 * @author Ylva Brandt 
 */

public class Huffman extends JFrame {
  // Anfang Attribute
  BinTreeZMZ hufbaum = new BinTreeZMZ();
  private JButton bDecodiere = new JButton();
  private JTextField jTextFieldText = new JTextField();
  private JButton bCodiere = new JButton();
  private JLabel lText = new JLabel();
  private JTextField jTextFieldCode = new JTextField();
  private JLabel lCode = new JLabel();
  private JButton bErstelleHuffmanBaum1 = new JButton();
  // Ende Attribute
  
  public Huffman() { 
    // Frame-Initialisierung
    super();
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 582; 
    int frameHeight = 300;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("Huffman");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    bErstelleHuffmanBaum1.setBounds(368, 96, 161, 25);
    bErstelleHuffmanBaum1.setText("erstelle Huffman-Baum");
    bErstelleHuffmanBaum1.setMargin(new Insets(2, 2, 2, 2));
    bErstelleHuffmanBaum1.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bErstelleHuffmanBaum1_ActionPerformed(evt);
      }
    });
    cp.add(bErstelleHuffmanBaum1);
    lCode.setBounds(12, 162, 62, 20);
    lCode.setText("Code:");
    cp.add(lCode);
    jTextFieldCode.setBounds(80, 160, 465, 33);
    cp.add(jTextFieldCode);
    lText.setBounds(8, 24, 57, 25);
    lText.setText("Text:");
    cp.add(lText);
    bCodiere.setBounds(248, 97, 91, 25);
    bCodiere.setText("codiere");
    bCodiere.setMargin(new Insets(2, 2, 2, 2));
    bCodiere.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bCodiere_ActionPerformed(evt);
      }
    });
    cp.add(bCodiere);
    jTextFieldText.setBounds(80, 24, 465, 33);
    cp.add(jTextFieldText);
    bDecodiere.setBounds(123, 98, 91, 25);
    bDecodiere.setText("decodiere");
    bDecodiere.setMargin(new Insets(2, 2, 2, 2));
    bDecodiere.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bDecodiere_ActionPerformed(evt);
      }
    });
    cp.add(bDecodiere);
    
    // Ende Komponenten
    
    setVisible(true);
    
  } // end of public 
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new Huffman();
     
  } // end of main
  
  //angepasste lösung zu Aufgabe 1 (decodieren)
  public void bDecodiere_ActionPerformed(ActionEvent evt) {
    if(hufbaum != null && jTextFieldCode.getText() != null){
      String eingabe = jTextFieldCode.getText();
      String text = decodiere(eingabe, hufbaum);
      jTextFieldText.setText(text);
    }else System.out.println("Kein Huffman-Baum oder leerer Code");
  } 
  
  public String decodiere(String hufcode, BinTreeZMZ baum){
    if (baum.isEmpty()) return "Fehler, der Huffman-Baum ist leer";
    String text = "";
    int zaehler = 0;
    while (zaehler < hufcode.length()) {
      BinTreeZMZ hilf = baum;
      while (!hilf.isLeaf()) {
        if (zaehler < hufcode.length()) {
          if (hufcode.charAt(zaehler) == '0')
            hilf = hilf.getLeft();
          else
            hilf = hilf.getRight();
          zaehler ++;
        } else break;
      }
      if(!hilf.isEmpty()) text = text + hilf.getItem().getZeichen();
    }
    return text;
  }


  //angepasste Lösung zu Aufgabe 2 (codieren)
  public void bCodiere_ActionPerformed(ActionEvent evt) {
    if(hufbaum != null && jTextFieldText.getText() != null){
      String eingabe = jTextFieldText.getText();
      String code = codiere(eingabe, hufbaum);
      jTextFieldCode.setText(code);
    } else System.out.println("Kein Huffman-Baum oder leerer Text");
  }
  
  public String codiere(String text, BinTreeZMZ baum){
    String code = "";
    for(int i = 0; i < text.length(); i++){
      BinTreeZMZ hilf = baum;
      char zeichen = text.charAt(i);
      while(!hilf.isLeaf()){
        BinTreeZMZ left = hilf.getLeft(); 
        if (!left.isEmpty() && left.getItem().getZeichenkette().contains("" + zeichen)) { //Auf die erste Bedingung kann verzichtet werden, wenn man aufgrund der Konstruktion eines Huffman-Baums davon ausgeht, dass Knoten, die keine Blätter sind, immer zwei Kinder mit Inhalt haben
          code = code + "0";
          hilf = hilf.getLeft();
        }else{
          BinTreeZMZ right = hilf.getRight();
          if (!right.isEmpty() && right.getItem().getZeichenkette().contains("" + zeichen)){
            code = code + "1";
            hilf = hilf.getRight();
          }else return "Fehler, es wurde ein Zeichen verwendet, das nicht im Baum enthalten ist!";
        } 
      }
    }
    return code;
  }
  
  //Hilfsmethode, die prüft, ob eine Zeichenketten ein Zeichen enthält
  public boolean enthaelt(String text, char zeichen){
    for(int i = 0; i < text.length(); i++){
      if(text.charAt(i) == zeichen){
        return true;     
      }
    }
    return false; 
  }
  //TODO
  public BinTreeZMZ erzeugeHuffman(String text){
    //mögliches Vorgehen:
    //1. Zeichen im Text zählen
    
    
    //2. sortierte Reihung mit Blättern erstellen (Blätter = Binärbaum mit Objekt der Klasse BinTreeZMZ, Inhalt ist jeweils ein Buchstabe mit der entsprechenden Anzahl
    
    //3. Huffman-Baum erzeugen, es werden jeweils die ersten zwei Teilbäume mit den kleinsten Wurzeln zu einem neuen Baum verbunden
    //die beiden Teilbäume werden entfernt und der neue Baum sortiert eingefügt
    return null;
  }
  public void bErstelleHuffmanBaum1_ActionPerformed(ActionEvent evt) {
    String text = jTextFieldText.getText();
    hufbaum = erzeugeHuffman(text);
    System.out.println(inorder(hufbaum));
  }
  
  //Hilfsmethode zur inorder-Ausgabe des Huffmanbaums
  public String inorder(BinTreeZMZ b){
    String erg = "";
    if(!b.isEmpty()){
      erg = erg + inorder(b.getLeft());
      erg = erg + b.getItem().toString() + "; ";
      erg = erg + inorder(b.getRight());
    }
    return erg;
  } 
  // Ende Methoden
  

} // end of class Huffman
